/*
 * Decompiled with CFR 0.152.
 */
package libsidutils;

import builder.resid.resample.Resampler;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import libsidplay.common.SamplingMethod;
import libsidplay.common.SamplingRate;
import libsidutils.IOUtils;

public class AudioUtils {
    private static final Logger LOG = Logger.getLogger(AudioUtils.class.getName());

    public static short[] convertToMonoWithSampleRate(InputStream is, long maxSeconds, SamplingRate sampleRate) throws IOException, UnsupportedAudioFileException {
        Buffer sourceBuffer;
        AudioInputStream stream = AudioSystem.getAudioInputStream(new BufferedInputStream(is));
        if (stream.getFormat().getSampleSizeInBits() != 16) {
            throw new IOException("Sample size in bits must be 16");
        }
        if (stream.getFormat().getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
            throw new IOException("Encoding must be " + AudioFormat.Encoding.PCM_SIGNED);
        }
        if (stream.getFormat().isBigEndian()) {
            throw new IOException("LittleEndian expected");
        }
        byte[] bytes = new byte[(int)Math.min((float)(stream.getFrameLength() * (long)stream.getFormat().getChannels() * 2L), (float)maxSeconds * stream.getFormat().getSampleRate() * (float)stream.getFormat().getChannels() * 2.0f)];
        int read = IOUtils.readNBytes(stream, bytes, 0, bytes.length);
        if (read < bytes.length && LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("Unexpected end of audio stream: read=%d, expected=%d", read, bytes.length));
        }
        if (stream.getFormat().getChannels() == 2) {
            ByteBuffer stereoBuffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
            ByteBuffer monoBuffer = ByteBuffer.allocate(bytes.length >> 1).order(ByteOrder.LITTLE_ENDIAN);
            while (stereoBuffer.hasRemaining()) {
                monoBuffer.putShort((short)(stereoBuffer.getShort() + stereoBuffer.getShort() >> 1));
            }
            bytes = monoBuffer.array();
        } else if (stream.getFormat().getChannels() != 1) {
            throw new IOException("Number of channels must be one or two");
        }
        int factor = 1;
        float srcSampleRate = stream.getFormat().getSampleRate();
        int targetSampleRate = sampleRate.getFrequency();
        if (srcSampleRate != (float)targetSampleRate) {
            while (srcSampleRate / (float)targetSampleRate < 2.0f) {
                srcSampleRate *= 2.0f;
                factor <<= 1;
            }
        }
        if (srcSampleRate > (float)targetSampleRate) {
            sourceBuffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
            ByteBuffer resampledBuffer = ByteBuffer.allocateDirect(factor * bytes.length).order(ByteOrder.LITTLE_ENDIAN);
            ResamplingState resamplingState = new ResamplingState();
            Resampler downSampler = Resampler.createResampler(srcSampleRate, SamplingMethod.RESAMPLE, targetSampleRate, sampleRate.getMiddleFrequency());
            while (sourceBuffer.hasRemaining()) {
                short val = ((ShortBuffer)sourceBuffer).get();
                for (int i = 0; i < factor; ++i) {
                    int dither = resamplingState.triangularDithering();
                    if (!downSampler.input(val) || resampledBuffer.putShort((short)Math.max(Math.min(downSampler.output() + dither, Short.MAX_VALUE), Short.MIN_VALUE)).hasRemaining()) continue;
                    ((Buffer)resampledBuffer).flip();
                }
            }
            bytes = new byte[resampledBuffer.position()];
            ((Buffer)resampledBuffer).rewind();
            resampledBuffer.get(bytes);
            factor = 1;
        }
        sourceBuffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
        ShortBuffer resultBuffer = ShortBuffer.allocate(bytes.length * factor << 1);
        while (sourceBuffer.hasRemaining()) {
            short val = ((ByteBuffer)sourceBuffer).getShort();
            for (int i = 0; i < factor; ++i) {
                resultBuffer.put(val);
            }
        }
        short[] shorts = new short[resultBuffer.position()];
        ((Buffer)resultBuffer).rewind();
        resultBuffer.get(shorts);
        return shorts;
    }

    private static class ResamplingState {
        private final Random RANDOM = new Random();
        private int oldRandomValue;

        private ResamplingState() {
        }

        private int triangularDithering() {
            int prevValue = this.oldRandomValue;
            this.oldRandomValue = this.RANDOM.nextInt() & 1;
            return this.oldRandomValue - prevValue;
        }
    }
}

